extends Spatial

onready var PLAYER_CHORO = $InfoPlayer/PlayerChrono # Label chrono
onready var LABEL_LAPS = $InfoPlayer/LAPS # Label laps

onready var MINI_CAM = $MiniMapViewport/Viewport/Camera # Caméra minimap
onready var CAR = $CarOne # Voiture

var CHECKPOINT_CURRENT = 0
var LAPS = 0
var time_passed := 0.0
var chrono_running := true

const MAX_CHECKPOINT = 10
const MAX_LAPS = 3

func _ready():
	LAPS_LOGIQUE()

func _process(delta):
	CHRONO_UPDATE(delta)
	MINIMAP_UPDATE()
	KEYBOARD()

func KEYBOARD():
	if Input.is_action_just_pressed("ui_cancel"):
		get_tree().change_scene("res://Scenes/Menu.tscn")
	if Input.is_action_just_pressed("Reset"):
		get_tree().change_scene("res://Scenes/RaceOne.tscn")

func pad_zeroes(num: int, length: int) -> String:
	var s = str(num)
	while s.length() < length:
		s = "0" + s
	return s

func CHRONO_UPDATE(delta):
	if chrono_running:
		time_passed += delta

		var total_seconds = int(time_passed)
		var minutes = total_seconds / 60
		var seconds = total_seconds % 60
		var milliseconds = int((time_passed - total_seconds) * 1000)

		var time_text = pad_zeroes(minutes, 2) + ":" + pad_zeroes(seconds, 2) + ":" + pad_zeroes(milliseconds, 3)
		PLAYER_CHORO.text = time_text

func LAPS_LOGIQUE():
	LABEL_LAPS.text = "LAPS: " + str(LAPS) + "/" + str(MAX_LAPS)
	if LAPS >= MAX_LAPS:
		print("GG")
		chrono_running = false

func MINIMAP_UPDATE():
	var car_pos = CAR.global_transform.origin
	var cam_pos = MINI_CAM.global_transform.origin
	cam_pos.x = car_pos.x
	cam_pos.z = car_pos.z
	MINI_CAM.global_transform.origin = cam_pos

# ----------- CHECKPOINTS -----------

func CheckPoint1(body):
	
	if CHECKPOINT_CURRENT == MAX_CHECKPOINT:
		LAPS += 1
		CHECKPOINT_CURRENT = 0
		LAPS_LOGIQUE()
	if CHECKPOINT_CURRENT == 0:
		CHECKPOINT_CURRENT = 1

func CheckPoint2(body):
	if CHECKPOINT_CURRENT == 1:
		CHECKPOINT_CURRENT = 2

func CheckPoint3(body):
	if CHECKPOINT_CURRENT == 2:
		CHECKPOINT_CURRENT = 3

func CheckPoint4(body):
	if CHECKPOINT_CURRENT == 3:
		CHECKPOINT_CURRENT = 4

func CheckPoint5(body):
	if CHECKPOINT_CURRENT == 4:
		CHECKPOINT_CURRENT = 5

func CheckPoint6(body):
	if CHECKPOINT_CURRENT == 5:
		CHECKPOINT_CURRENT = 6

func CheckPoint7(body):
	if CHECKPOINT_CURRENT == 6:
		CHECKPOINT_CURRENT = 7

func CheckPoint8(body):
	if CHECKPOINT_CURRENT == 7:
		CHECKPOINT_CURRENT = 8

func CheckPoint9(body):
	if CHECKPOINT_CURRENT == 8:
		CHECKPOINT_CURRENT = 9

func CheckPoint10(body):
	if CHECKPOINT_CURRENT == 9:
		CHECKPOINT_CURRENT = 10
